% "Survey density forecast comparison in small samples" 
% by Laura Coroneo, Fabrizio Iacone and Fabio Profumo, 
% International Journal of Forecasting, 2024


% This code replicates Figure 2, the histogram of the aggregate HICP 
% one-year ahead forecast from the 2016.Q1 survey round.

clear; clc;

%% Declare variables
sample_sel = [datetime('01-01-2000','InputFormat','MM-dd-yyyy') datetime('12-01-2019','InputFormat','MM-dd-yyyy')];

variable = 'HICP';

round = '2016Q1'; %2016.Q1 HICP SPF Round, forecast 1year ahead is Dec 2016
%% Load data
[SPF] = load_data(variable, sample_sel);

target = find(SPF.dates_surveys==datetime(round, 'InputFormat','yyyyQQQ'),1,"first");

lex = [SPF.edges(target,:)];

lex(1) = -1.5;

lex(13) = 4.5;

%% Plot
bar(lex, [SPF.data(target, :,1) NaN]')

xlim([-2 4.5])
ylim([0 0.35])

set(gca,'XTick',-1.5:0.5:4)

xticklabels({'<-1%','-1 to -0.6%','-0.5% to -0.1%','0.0 to 0.4%','0.5 to 0.9%','1.0 to 1.4%',...
    '1.5 to 1.9%', '2.0 to 2.4%', '2.5 to 2.9%', '3.0 to 3.4%', '3.5 to 3.9%', '>4.0%'})

xtickangle(45)

title('Figure 2: ECB SPF density forecast for HICP one-year ahead, December 2016')

xlabel('Bins');

ylabel('Probabilty');

set(gca,'FontSize',10)